// Scilab : 6.0.0
// OS: Windows 7, 64 bit
// Lab 7: To Study the Effect of Time Delay on System Response
clc ;
clear all;

// For T = 0, i.e. No Delay
s=poly(0,'s')
// Transfer Function of Open-Loop System with T=0
G1=syslin('c',exp(0)*10/((s)*(s+1)));
figure(0)
bode(G1,0.1,100)
[gm1,frg1]=g_margin(G1);
disp(gm1,"Gain Margin,T=0",frg1,"Phase Cut-off Frequency, T=0")
show_margins(G1)
[phm1,frp1]=p_margin(G1);
disp(phm1,"Phase Margin, T=0",frp1,"Gain Cut-off Frequency, T=0")
show_margins(G1)

// For Time Delay T = 0.1
T=0.1;
nTd=[1-T*s/2]; dTd=[1+T*s/2];// Num and Den of Delay System by Pade
sysTd=syslin('c',nTd/dTd);
G2=syslin('c',(sysTd*10)/((s)*(s+1)));
figure(1)
bode(G2,0.1,100)
[gm2,frg2]=g_margin(G2);
disp(gm2,"Gain Margin, T=0.1",frg2,"Phase Cut-off Frequency, T=0.1")
show_margins(G2)
[phm2,frp2]=p_margin(G2);
disp(phm2,"Phase Margin, T=0.1",frp2,"Gain Cut-off Frequency, T=0.1")
show_margins(G2)

// Results
// Frequency Response Specifications of Un-Compensated System
//Phase Cut-off Frequency, T=0
//
//    []
//
// Gain Margin,T=0
//
//   Inf
//
// Gain Cut-off Frequency, T=0
//
//   0.4908709
//
// Phase Margin, T=0

//   17.964236
// Frequency Response Specifications of Compensated System

// Phase Cut-off Frequency, T=0.1
//
//   0.4971165
//
// Gain Margin, T=0.1
//
//   0.2093087
//
// Gain Cut-off Frequency, T=0.1
//
//   0.4908709
//
// Phase Margin, T=0.1

//   0.4310002

